/* @(#) somx/student.c 2.3 1/20/94 10:21:31 [5/15/94 17:59:07] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#include <somp.h>
#include <string.h>

#define PersistentStudent_Class_Source
#include "student.ih"


#ifdef __IBMC__
  #pragma linkage(SOMInitModule, system)
  #pragma linkage(SOMInitSOMPIni, system)
#endif /* __IBMC__ */

SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion)
{
  PersistentStudentNewClass(PersistentStudent_MajorVersion, PersistentStudent_MinorVersion);
}

SOMEXTERN void SOMLINK SOMInitPersistentStudent ()
{
   SOMInitModule(0L, 0L);
}


/*
 *Method from the IDL attribute statement:
 *"attribute string id"
 */

SOM_Scope void  SOMLINK _set_id(PersistentStudent somSelf,  Environment *ev,
                                string id)
{
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","_set_id");
    if (_id) SOMFree(_id);
    _id = SOMMalloc(strlen(id)+1);
    strcpy(_id, id);
}

/*
 *Method from the IDL attribute statement:
 *"attribute string name"
 */

SOM_Scope void  SOMLINK _set_name(PersistentStudent somSelf,
                                   Environment *ev, string name)
{
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","_set_name");
    if (_name) SOMFree(_name);
    _name = SOMMalloc(strlen(name)+1);
    strcpy(_name, name);
}

/*
 * sets up a new student.
 */

SOM_Scope void  SOMLINK setUpStudent(PersistentStudent somSelf,
                                      Environment *ev, string id,
                                     string name)
{
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","setUpStudent");
    __set_id(somSelf, ev, id);
    __set_name(somSelf, ev, name);
}

/*
 * prints the student information.
 */

SOM_Scope void  SOMLINK printStudentInfo(PersistentStudent somSelf,
                                          Environment *ev)
{
    string id;
    string name;
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","printStudentInfo");

    id = __get_id(somSelf, ev);
    name = _get_name(somSelf, ev);
    if (id)
       somPrintf("\n     Id      : %s \n", id);
    else
       somPrintf("\n     Id      : \n");
    if (name)
       somPrintf("    Name      : %s \n", name);
    else
       somPrintf("    Name      : \n");
    somPrintf("    Type      : %s \n", _getStudentType(somSelf, ev));
}

/*
 * returns the student type.
 */

SOM_Scope string  SOMLINK getStudentType(PersistentStudent somSelf,
                                          Environment *ev)
{
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","getStudentType");

    return ("Student");
}

SOM_Scope void  SOMLINK somInit(PersistentStudent somSelf)
{
    PersistentStudentData *somThis = PersistentStudentGetData(somSelf);
    PersistentStudentMethodDebug("PersistentStudent","somInit");

    PersistentStudent_parent_SOMPPersistentObject_somInit(somSelf);
    _id = _name = NULL;
}

